# 导入
如果把所有的代码都放在一个文件里，很快就会变得难以管理。
使用 `import` 语句可从另一个文件导入函数和全局变量。
一张截图说明它的工作原理：
![](ImportsInOnePicture400)

这里 `import module2` 会运行名为 `module2` 的文件，让你能访问其中所有的全局变量。
然后你可以使用 `.` 运算符来访问导入模块中的变量和函数。
所以在这个例子中，`module2.print_x()` 调用了 `module2` 中的 `print_x()`。

### 无需继续阅读

你也可以使用 `from` 语法，将导入模块中的全局变量移到执行 import 语句的当前作用域中。

`from module2 import print_x
print_x()`
只从 `module2` 导入指定的全局变量。

或者

`from module2 import *
print_x()`
从 `module2` 导入所有全局变量。

这同样会导入 `module2` 文件，但不是通过一个名为 `module2` 的变量来访问它，而是将 `module2` 中的全局变量解包并直接赋给局部作用域。

通常不推荐这种导入形式，因为它在两个文件相互导入时效果不佳，而且你可能会因为命名冲突而意外覆盖导入文件中的变量。如果不清楚自己在做什么，最好避免使用 `from` 语法。

# 真实工作原理

## 省流版说明
`import` 可能 不如 `from` 直观
但只要确保使用 `import file` 语法而非 `from file import`，并将所有不是全局定义的内容包裹在如下代码块中：
`if __name__ == "__main__":`
就可以避免大多数问题。

## 导入的副作用
第一次导入一个文件时，会完整执行一遍这个文件，然后让你能访问在执行过程中定义的所有变量。
如果再次导入同一个文件，则只会再次返回第一次的缓存模块。

这意味着 import 语句可能会有这样的副作用：如果导入一个调用了 `harvest()` 的文件，会在导入过程中真的会执行收获。但再次导入时，因为文件只运行一次，所以不会再次收获。

若要避免这种副作用，可以使用 `__name__` 变量。这个变量在文件被直接运行时，会被自动设置为 `"__main__"`；在文件通过 `import` 运行时，则会被设置为该文件的名字。
一种好的做法是，将任何你不想在文件被导入时运行的代码，都放在 `if __name__ == "__main__":` 代码块中。

在 Python 中，一个常见的文件结构就是，把文件运行时应执行的代码放入 `main()` 函数中。这样，你就能清楚地区分局部变量（在 `main()` 内部定义）和可以被导入的全局变量（在 `main()` 外部定义）。

`a_global_variable = "global"

def main():
    a_local_variable = "local"
    # 执行某些操作

if __name__ == "__main__":
    main()`

## 导入循环
如果文件 `a` 导入文件 `b`，同时文件 `b` 又导入文件 `a`，会发生什么？

文件 `a`：
`import b
x = 0`

文件 `b`：
`import a
def f():
    print(a.x)`

这样写是没问题的。假设这两个文件都还没有被加载，然后其他人执行了 `import a`。

- `a` 运行到 `import b` 这一行，切换到运行 `b`。
- `b` 运行到 `import a` 这一行。
- 缓存模块 `a` 已经存在，但不包含 `x`，因为它只运行到了 `import b` 这一行。
- `b` 将对加载了一半的模块 `a` 的引用存储在一个名为 `a` 的变量中。
- `b` 运行 `def` 语句并存储函数 `f()`。`b` 现在已经完全加载。
- `a` 继续运行并初始化 `x`。

当有人调用 `b.f()` 时，`0` 会被正确打印出来，因为 `b` 所引用的模块 `a` 现已完全加载。

现在来看看使用 `from` 语法的相同代码。

文件 `a`：
`from b import *
x = 0`

文件 `b`：
`from a import *
def f():
    print(x)`

- `a` 运行到 `from b import *` 这一行。
- `b` 运行到 `from a import *` 这一行。
- 模块 `a` 已经存在，但还没有被完全执行。
- `b` 将 `a` 中当前存在的所有内容解包到它自己的全局作用域中。此时，`a` 什么也不包含，因为它还没有运行到 `x = 0` 这一行，所以什么也没有被导入。
- `b` 运行 `def` 语句并存储函数 `f()`。
- `a` 继续运行并初始化 `x`。

如果现在有人调用 `b.f()`，则会收到错误，提示 `x` 在当前作用域中不存在。这是因为这一次 `b` 没有一个指向仍在加载中的 `a` 的引用，也看不到在导入之后才添加的定义。